/*

WFDB_putinfo.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define INFO_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i, err_code;

  mxArray *cell;
  unsigned int ninfo, info_length;
  char *info;

  /* Get INFO string(s) */
  if (mxIsCell(prhs[INFO_INPUT]))
    {
      ninfo = mxGetM(prhs[INFO_INPUT]) * mxGetN(prhs[INFO_INPUT]);
      for (i = 0; i < ninfo; i++)
	{
	  cell = mxGetCell(prhs[INFO_INPUT], i);
	  info_length = (mxGetM(cell) * mxGetN(cell)) + 1;
	  info = mxCalloc(info_length, sizeof(char));
	  mxGetString(cell, info, info_length);
	  if ((err_code = putinfo(info)) < 0)
	    switch (err_code)
	      {
	      case -1:
		mexErrMsgTxt("Failure: header not initialized");
	      default:
		mexErrMsgTxt("Unknown error");
	      }
	}
    }
  else
    {
      info_length = (mxGetM(prhs[INFO_INPUT]) *
		     mxGetN(prhs[INFO_INPUT])) + 1;
      info = mxCalloc(info_length, sizeof(char));
      mxGetString(prhs[INFO_INPUT], info, info_length);
      if ((err_code = putinfo(info)) < 0)
	switch (err_code)
	  {
	  case -1:
	    mexErrMsgTxt("Failure: header not initialized");
	  default:
	    mexErrMsgTxt("Unknown error");
	  }

    }

  mxFree(info);
}
