/*
 * WFDB_isigsettime.c
 *
 */
 
#include "mex.h"
#include "wfdb/wfdb.h"

/* Define order of input variables */
#define TIME_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  int err_code;

  if (nrhs == 1)
    {
      err_code = isigsettime(*mxGetPr(prhs[TIME_INPUT]));
      if (err_code < 0)
	if (err_code == -1)
	  mexErrMsgTxt("Failure: EOF reached or improper seek");
	else
	  mexErrMsgTxt("Unknown error code");
    }
  else
    mexErrMsgTxt("One input argument required");

}
