% file: example.m	G. Clifford and G. Moody	27 November 2003

fprintf('example.m - demonstration of the WFDB_tools wrappers for Matlab\n')

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script is part of a brief 'hands on' tutorial for the WFDB_tools
% package.  It runs the other five scripts (example1.m, example2.m ...)
% in this directory in order.  Before running any of these scripts, you
% will need to have correctly installed the WFDB software package and
% added the Matlab WFDB_tools path at the Matlab prompt.
%
% Please report any problems with this script to Gari Clifford:
%	gari AT physionet DOT org
% Please report any problems with WFDB_tools for Matlab to Jonas Carlson:
%       jonas DOT carlson AT kard DOT lu DOT se
% Please report any problems with the WFDB software package to George Moody:
%       george AT physionet DOT org

% Set pauseflag to 0 before running this script to disable pauses.
if(~exist('pauseflag')) pauseflag=1; end

% Check that the WFDB_tools functions are installed and accessible.
if(exist('WFDB_isigopen')==0)
  fprintf('Please add WFDB_tools to the PATH ...');
  if(isunix)
     error(' e.g.,\n     addpath ~/matlab/WFDB_tools/\n');
  elseif(ispc)
     error(' e.g.,\n     addpath c:\\matlab\\WFDB_tools\n');
  else
     error('... ');
  end
end

% Check that the WFDB software package is installed and accessible.
if system('rdann -r mitdb/201 -a atr -c 1')
  fprintf('The WFDB software package does not seem to be installed.\n');
  error('Install it and add the directory containing "rdann" to your PATH.\n');
end

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% End of standard setup.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Run the examples.
example1; 

if(pauseflag==1)
  fprintf('               [Press any key to continue with example 2]\n'); 
  pause;
end;
example2;

if(pauseflag==1)
  fprintf('               [Press any key to continue with example 3]\n'); 
  pause;
end;
example3;

if(pauseflag==1)
  fprintf('               [Press any key to continue with example 4]\n'); 
  pause;
end;
example4;

if(pauseflag==1)
  fprintf('               [Press any key to continue with example 5]\n'); 
  pause;
end;
example5;

fprintf('End of demonstration.\n');