% S = WFDB_Siginfo(NSIG);
%
% Create Siginfo structure(s) for use with WFDB_osigfopen.
%
% NSIG: Number of signals
% S: Resulting Siginfo structure(s)
%
% The fields of S are defaulted as:
%   fname - 'record.dat'
%   desc - 'Signal 0', Signal 1', ...
%   units - 'mV'
%   gain - 200
%   initval - 0
%   group - 0
%   fmt - 16
%   spf - 1
%   bsize - 0
%   adcres - 12
%   adczero - 0
%   baseline - 0
%
% http://www.physionet.org

function S = WFDB_Siginfo(NSIG);

for ii = 1:NSIG
    S(ii) = struct('fname', 'record.dat', ...
        'desc', ['Signal ' num2str(ii-1)], ...
        'units', 'mV', ...
        'gain', 200, ...
        'initval', 0, ...
        'group', 0, ...
        'fmt', 16, ...
        'spf', 1, ...
        'bsize', 0, ...
        'adcres', 12, ...
        'adczero', 0, ...
        'baseline', 0);
end
