/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantDoubleInfo;
import org.gjt.jclasslib.structures.constants.ConstantFieldrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantFloatInfo;
import org.gjt.jclasslib.structures.constants.ConstantIntegerInfo;
import org.gjt.jclasslib.structures.constants.ConstantInterfaceMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantLongInfo;
import org.gjt.jclasslib.structures.constants.ConstantMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.gjt.jclasslib.structures.constants.ConstantStringInfo;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public abstract class CPInfo
extends AbstractStructure {
    public static final byte CONSTANT_CLASS = 7;
    public static final byte CONSTANT_FIELDREF = 9;
    public static final byte CONSTANT_METHODREF = 10;
    public static final byte CONSTANT_INTERFACE_METHODREF = 11;
    public static final byte CONSTANT_STRING = 8;
    public static final byte CONSTANT_INTEGER = 3;
    public static final byte CONSTANT_FLOAT = 4;
    public static final byte CONSTANT_LONG = 5;
    public static final byte CONSTANT_DOUBLE = 6;
    public static final byte CONSTANT_NAME_AND_TYPE = 12;
    public static final byte CONSTANT_UTF8 = 1;
    public static final String CONSTANT_CLASS_VERBOSE = "CONSTANT_Class_info";
    public static final String CONSTANT_FIELDREF_VERBOSE = "CONSTANT_Fieldref_info";
    public static final String CONSTANT_METHODREF_VERBOSE = "CONSTANT_Methodref_info";
    public static final String CONSTANT_INTERFACE_METHODREF_VERBOSE = "CONSTANT_InterfaceMethodref_info";
    public static final String CONSTANT_STRING_VERBOSE = "CONSTANT_String_info";
    public static final String CONSTANT_INTEGER_VERBOSE = "CONSTANT_Integer_info";
    public static final String CONSTANT_FLOAT_VERBOSE = "CONSTANT_Float_info";
    public static final String CONSTANT_LONG_VERBOSE = "CONSTANT_Long_info";
    public static final String CONSTANT_DOUBLE_VERBOSE = "CONSTANT_Double_info";
    public static final String CONSTANT_NAME_AND_TYPE_VERBOSE = "CONSTANT_NameAndType_info";
    public static final String CONSTANT_UTF8_VERBOSE = "CONSTANT_Utf8_info";

    public static CPInfo create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        CPInfo cPInfo;
        byte by = dataInput.readByte();
        switch (by) {
            case 7: {
                cPInfo = new ConstantClassInfo();
                break;
            }
            case 9: {
                cPInfo = new ConstantFieldrefInfo();
                break;
            }
            case 10: {
                cPInfo = new ConstantMethodrefInfo();
                break;
            }
            case 11: {
                cPInfo = new ConstantInterfaceMethodrefInfo();
                break;
            }
            case 8: {
                cPInfo = new ConstantStringInfo();
                break;
            }
            case 3: {
                cPInfo = new ConstantIntegerInfo();
                break;
            }
            case 4: {
                cPInfo = new ConstantFloatInfo();
                break;
            }
            case 5: {
                cPInfo = new ConstantLongInfo();
                break;
            }
            case 6: {
                cPInfo = new ConstantDoubleInfo();
                break;
            }
            case 12: {
                cPInfo = new ConstantNameAndTypeInfo();
                break;
            }
            case 1: {
                cPInfo = new ConstantUtf8Info();
                break;
            }
            default: {
                throw new InvalidByteCodeException("invalid constant pool entry with unknown tag " + by);
            }
        }
        cPInfo.setClassFile(classFile);
        cPInfo.read(dataInput);
        return cPInfo;
    }

    public abstract byte getTag();

    public abstract String getTagVerbose();

    public String getVerbose() throws InvalidByteCodeException {
        return "";
    }

    public static int skip(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = 0;
        byte by = dataInput.readByte();
        switch (by) {
            case 7: {
                dataInput.skipBytes(2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                dataInput.skipBytes(4);
                break;
            }
            case 8: {
                dataInput.skipBytes(2);
                break;
            }
            case 3: 
            case 4: {
                dataInput.skipBytes(4);
                break;
            }
            case 5: 
            case 6: {
                dataInput.skipBytes(8);
                n = 1;
                break;
            }
            case 12: {
                dataInput.skipBytes(4);
                break;
            }
            case 1: {
                dataInput.skipBytes(dataInput.readUnsignedShort());
                break;
            }
            default: {
                throw new InvalidByteCodeException("invalid constant pool entry with unknown tag " + by);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof CPInfo;
    }

    public int hashCode() {
        return 0;
    }
}

