/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.gjt.jclasslib.mdi.BasicDesktopManager;
import org.gjt.jclasslib.mdi.BasicInternalFrame;
import org.gjt.jclasslib.mdi.MDIConfig;
import org.gjt.jclasslib.util.GUIHelper;

public class BasicMDIFrame
extends JFrame {
    private static final int DEFAULT_WINDOW_WIDTH = 800;
    private static final int DEFAULT_WINDOW_HEIGHT = 600;
    private static final String SETTINGS_WINDOW_WIDTH = "windowWidth";
    private static final String SETTINGS_WINDOW_HEIGHT = "windowHeight";
    private static final String SETTINGS_WINDOW_X = "windowX";
    private static final String SETTINGS_WINDOW_Y = "windowY";
    private static final String SETTINGS_WINDOW_MAXIMIZED = "windowMaximized";
    protected Action actionNextWindow;
    protected Action actionPreviousWindow;
    protected Action actionTileWindows;
    protected Action actionStackWindows;
    protected JScrollPane scpDesktop;
    protected JDesktopPane desktopPane;
    protected BasicDesktopManager desktopManager;
    protected JMenu menuWindow;
    private Rectangle lastNormalFrameBounds;

    public BasicMDIFrame() {
        this.setupActions();
        this.setupMenu();
        this.setupFrame();
        this.setupEventHandlers();
        this.loadWindowSettings();
    }

    protected BasicDesktopManager createDesktopManager() {
        return new BasicDesktopManager(this);
    }

    protected void doQuit() {
        this.saveWindowSettings();
        this.dispose();
        System.exit(0);
    }

    protected void closeAllFrames() {
        List list = this.desktopManager.getOpenFrames();
        while (list.size() > 0) {
            BasicInternalFrame basicInternalFrame = (BasicInternalFrame)list.get(0);
            basicInternalFrame.doDefaultCloseAction();
        }
    }

    protected MDIConfig createMDIConfig() {
        MDIConfig mDIConfig = new MDIConfig();
        List list = this.desktopManager.getOpenFrames();
        ArrayList<MDIConfig.InternalFrameDesc> arrayList = new ArrayList<MDIConfig.InternalFrameDesc>(list.size());
        int n = 0;
        while (n < list.size()) {
            BasicInternalFrame basicInternalFrame = (BasicInternalFrame)list.get(n);
            Rectangle rectangle = basicInternalFrame.getNormalBounds();
            MDIConfig.InternalFrameDesc internalFrameDesc = new MDIConfig.InternalFrameDesc();
            internalFrameDesc.setClassName(basicInternalFrame.getClass().getName());
            internalFrameDesc.setInitParam(basicInternalFrame.getInitParam());
            internalFrameDesc.setX(rectangle.x);
            internalFrameDesc.setY(rectangle.y);
            internalFrameDesc.setWidth(rectangle.width);
            internalFrameDesc.setHeight(rectangle.height);
            internalFrameDesc.setMaximized(basicInternalFrame.isMaximum());
            internalFrameDesc.setIconified(basicInternalFrame.isIcon());
            if (basicInternalFrame == this.desktopPane.getSelectedFrame()) {
                mDIConfig.setActiveFrameDesc(internalFrameDesc);
            }
            arrayList.add(internalFrameDesc);
            ++n;
        }
        mDIConfig.setInternalFrameDescs(arrayList);
        return mDIConfig;
    }

    protected void readMDIConfig(MDIConfig mDIConfig) {
        boolean bl = false;
        Iterator iterator = mDIConfig.getInternalFrameDescs().iterator();
        while (iterator.hasNext()) {
            Constructor<?> constructor;
            Serializable serializable;
            MDIConfig.InternalFrameDesc internalFrameDesc = (MDIConfig.InternalFrameDesc)iterator.next();
            try {
                serializable = Class.forName(internalFrameDesc.getClassName());
                constructor = ((Class)serializable).getConstructor(this.getFrameConstructorArguments((Class)serializable));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("class not found:" + classNotFoundException.getMessage());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("constructor not found:" + noSuchMethodException.getMessage());
                continue;
            }
            try {
                serializable = (BasicInternalFrame)constructor.newInstance(this.desktopManager, internalFrameDesc.getInitParam());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Throwable throwable = exception.getCause();
                if (throwable == null) continue;
                exception.printStackTrace();
                continue;
            }
            this.desktopManager.resizeFrame((JComponent)serializable, internalFrameDesc.getX(), internalFrameDesc.getY(), internalFrameDesc.getWidth(), internalFrameDesc.getHeight());
            boolean bl2 = internalFrameDesc.isMaximized();
            bl = bl || bl2;
            try {
                if (bl2 || bl) {
                    ((JInternalFrame)serializable).setMaximum(true);
                } else if (internalFrameDesc.isIconified()) {
                    ((JInternalFrame)serializable).setIcon(true);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (internalFrameDesc != mDIConfig.getActiveFrameDesc()) continue;
            this.desktopManager.setActiveFrame((BasicInternalFrame)serializable);
        }
        this.desktopManager.showAll();
    }

    protected Class[] getFrameConstructorArguments(Class clazz) {
        return BasicInternalFrame.CONSTRUCTOR_ARGUMENTS;
    }

    private void setupActions() {
        this.actionNextWindow = new WindowAction("Next window");
        this.actionNextWindow.putValue("ShortDescription", "Cycle to the next opened window");
        this.actionNextWindow.setEnabled(false);
        this.actionPreviousWindow = new WindowAction("Previous window");
        this.actionPreviousWindow.putValue("ShortDescription", "Cycle to the previous opened window");
        this.actionPreviousWindow.setEnabled(false);
        this.actionTileWindows = new WindowAction("Tile windows");
        this.actionTileWindows.putValue("ShortDescription", "Tile all windows in the main frame");
        this.actionTileWindows.setEnabled(false);
        this.actionStackWindows = new WindowAction("Stack windows");
        this.actionStackWindows.putValue("ShortDescription", "Stack all windows in the main frame");
        this.actionStackWindows.setEnabled(false);
    }

    private void setupMenu() {
        this.menuWindow = new JMenu("Window");
        this.menuWindow.add(this.actionPreviousWindow).setAccelerator(KeyStroke.getKeyStroke(113, 2));
        this.menuWindow.add(this.actionNextWindow).setAccelerator(KeyStroke.getKeyStroke(114, 2));
        this.menuWindow.add(this.actionTileWindows);
        this.menuWindow.add(this.actionStackWindows);
    }

    private void setupFrame() {
        this.setDefaultCloseOperation(0);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)this.buildDesktop(), "Center");
    }

    private void setupEventHandlers() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BasicMDIFrame.this.doQuit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BasicMDIFrame.this.desktopManager.checkResizeInMaximizedState();
                BasicMDIFrame.this.recordLastNormalFrameBounds();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                BasicMDIFrame.this.recordLastNormalFrameBounds();
            }
        });
    }

    private void saveWindowSettings() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        boolean bl = (this.getExtendedState() & 6) != 0;
        preferences.putBoolean(SETTINGS_WINDOW_MAXIMIZED, bl);
        Rectangle rectangle = bl ? this.lastNormalFrameBounds : this.getBounds();
        preferences.putInt(SETTINGS_WINDOW_WIDTH, rectangle.width);
        preferences.putInt(SETTINGS_WINDOW_HEIGHT, rectangle.height);
        preferences.putInt(SETTINGS_WINDOW_X, rectangle.x);
        preferences.putInt(SETTINGS_WINDOW_Y, rectangle.y);
    }

    private void loadWindowSettings() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(dimension);
        int n = preferences.getInt(SETTINGS_WINDOW_X, (int)(dimension.getWidth() - 800.0) / 2);
        int n2 = preferences.getInt(SETTINGS_WINDOW_Y, (int)(dimension.getHeight() - 600.0) / 2);
        int n3 = preferences.getInt(SETTINGS_WINDOW_WIDTH, 800);
        int n4 = preferences.getInt(SETTINGS_WINDOW_HEIGHT, 600);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        rectangle2.translate(-Math.min(0, rectangle2.x), -Math.min(0, rectangle2.y));
        rectangle2.translate(-Math.max(0, rectangle2.x + rectangle2.width - dimension.width), -Math.max(0, rectangle2.y + rectangle2.height - dimension.height));
        rectangle2 = rectangle.intersection(rectangle2);
        this.setBounds(rectangle2);
        if (preferences.getBoolean(SETTINGS_WINDOW_MAXIMIZED, false)) {
            this.setExtendedState(6);
        }
    }

    private void recordLastNormalFrameBounds() {
        Rectangle rectangle;
        if ((this.getExtendedState() & 6) == 0 && (rectangle = this.getBounds()).getX() >= 0.0 && rectangle.getY() >= 0.0) {
            this.lastNormalFrameBounds = rectangle;
        }
    }

    private JComponent buildDesktop() {
        this.desktopPane = new JDesktopPane();
        this.desktopManager = this.createDesktopManager();
        this.desktopPane.setDesktopManager(this.desktopManager);
        this.scpDesktop = new JScrollPane(this.desktopPane);
        GUIHelper.setDefaultScrollbarUnits(this.scpDesktop);
        return this.scpDesktop;
    }

    private class WindowAction
    extends AbstractAction {
        private WindowAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this == BasicMDIFrame.this.actionPreviousWindow) {
                BasicMDIFrame.this.desktopManager.cycleToPreviousWindow();
            } else if (this == BasicMDIFrame.this.actionNextWindow) {
                BasicMDIFrame.this.desktopManager.cycleToNextWindow();
            } else if (this == BasicMDIFrame.this.actionTileWindows) {
                BasicMDIFrame.this.desktopManager.tileWindows();
            } else if (this == BasicMDIFrame.this.actionStackWindows) {
                BasicMDIFrame.this.desktopManager.stackWindows();
            }
        }
    }
}

