/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.io.File;
import javax.swing.tree.DefaultTreeModel;
import org.gjt.jclasslib.browser.config.classpath.ClassTreeNode;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.browser.config.classpath.FindResult;

public class ClasspathDirectoryEntry
extends ClasspathEntry {
    public FindResult findClass(String string) {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string.replace('.', '/') + ".class");
        if (file2.exists() && file2.canRead()) {
            FindResult findResult = new FindResult(this, file2.getPath());
            return findResult;
        }
        return null;
    }

    public void mergeClassesIntoTree(DefaultTreeModel defaultTreeModel, boolean bl) {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        ClassTreeNode classTreeNode = (ClassTreeNode)defaultTreeModel.getRoot();
        this.mergeDirectory(file, classTreeNode, defaultTreeModel, bl);
    }

    private void mergeDirectory(File file, ClassTreeNode classTreeNode, DefaultTreeModel defaultTreeModel, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                ClassTreeNode classTreeNode2 = this.addOrFindNode(file2.getName(), classTreeNode, true, defaultTreeModel, bl);
                this.mergeDirectory(file2, classTreeNode2, defaultTreeModel, bl);
                if (classTreeNode2.getChildCount() == 0) {
                    int n2 = classTreeNode.getIndex(classTreeNode2);
                    classTreeNode.remove(classTreeNode2);
                    if (!bl) {
                        defaultTreeModel.nodesWereRemoved(classTreeNode, new int[]{n2}, new Object[]{classTreeNode2});
                    }
                }
            } else if (file2.getName().toLowerCase().endsWith(".class")) {
                this.addOrFindNode(this.stripClassSuffix(file2.getName()), classTreeNode, false, defaultTreeModel, bl);
            }
            ++n;
        }
    }
}

