/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ConstantUtf8Info
extends CPInfo {
    private byte[] bytes;
    private String string;

    public byte getTag() {
        return 1;
    }

    public String getTagVerbose() {
        return "CONSTANT_Utf8_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return this.string;
    }

    public byte[] getBytes() {
        return this.string.getBytes();
    }

    public String getString() {
        return this.string;
    }

    public void setBytes(byte[] byArray) {
        this.string = new String(byArray);
    }

    public void setString(String string) {
        this.string = string;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.string = dataInput.readUTF();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(1);
        dataOutput.writeUTF(this.string);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with length " + this.getLength(this.bytes) + " (\"" + this.string + "\")");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstantUtf8Info)) {
            return false;
        }
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)object;
        return super.equals(object) && constantUtf8Info.string.equals(this.string);
    }

    public int hashCode() {
        return super.hashCode() ^ this.string.hashCode();
    }
}

