/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.mdi;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.gjt.jclasslib.mdi.BasicInternalFrame;
import org.gjt.jclasslib.mdi.BasicMDIFrame;

public class BasicDesktopManager
extends DefaultDesktopManager
implements VetoableChangeListener,
InternalFrameListener {
    private static int NEW_INTERNAL_X_OFFSET = 22;
    private static int NEW_INTERNAL_Y_OFFSET = 22;
    private static int NEW_INTERNAL_WIDTH = 600;
    private static int NEW_INTERNAL_HEIGHT = 400;
    protected BasicMDIFrame parentFrame;
    private int newInternalX = 0;
    private int newInternalY = 0;
    private JDesktopPane desktopPane;
    private HashMap frameToMenuItem = new HashMap();
    private BasicInternalFrame activeFrame;
    private LinkedList openFrames = new LinkedList();
    private int rollover = 0;
    private int separatorMenuIndex = -1;
    private boolean maximizationInProgress;
    private boolean anyFrameMaximized;

    public BasicDesktopManager(BasicMDIFrame basicMDIFrame) {
        this.parentFrame = basicMDIFrame;
        this.desktopPane = basicMDIFrame.desktopPane;
    }

    public BasicMDIFrame getParentFrame() {
        return this.parentFrame;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public List getOpenFrames() {
        return this.openFrames;
    }

    public Rectangle getNextInternalFrameBounds() {
        if (this.newInternalY + NEW_INTERNAL_HEIGHT > this.desktopPane.getHeight()) {
            ++this.rollover;
            this.newInternalY = 0;
            this.newInternalX = this.rollover * NEW_INTERNAL_X_OFFSET;
        }
        Rectangle rectangle = new Rectangle(this.newInternalX, this.newInternalY, NEW_INTERNAL_WIDTH, NEW_INTERNAL_HEIGHT);
        this.newInternalX += NEW_INTERNAL_X_OFFSET;
        this.newInternalY += NEW_INTERNAL_Y_OFFSET;
        return rectangle;
    }

    public void setActiveFrame(BasicInternalFrame basicInternalFrame) {
        this.activeFrame = basicInternalFrame;
    }

    public BasicInternalFrame getOpenFrame(Object object) {
        Iterator iterator = this.openFrames.iterator();
        while (iterator.hasNext()) {
            BasicInternalFrame basicInternalFrame = (BasicInternalFrame)iterator.next();
            if (!basicInternalFrame.getInitParam().equals(object)) continue;
            return basicInternalFrame;
        }
        return null;
    }

    public void showAll() {
        Iterator iterator = this.openFrames.iterator();
        while (iterator.hasNext()) {
            ((BasicInternalFrame)iterator.next()).setVisible(true);
        }
        if (this.activeFrame != null) {
            try {
                this.activeFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.checkSize();
    }

    public void addInternalFrame(JInternalFrame jInternalFrame) {
        jInternalFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BasicDesktopManager.this.checkSize();
            }
        });
        if (this.frameToMenuItem.size() == 0) {
            this.separatorMenuIndex = this.parentFrame.menuWindow.getMenuComponentCount();
            this.parentFrame.menuWindow.addSeparator();
        }
        WindowActivateAction windowActivateAction = new WindowActivateAction(jInternalFrame);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(windowActivateAction);
        jCheckBoxMenuItem.setSelected(false);
        this.parentFrame.menuWindow.add(jCheckBoxMenuItem);
        this.desktopPane.add(jInternalFrame);
        this.frameToMenuItem.put(jInternalFrame, jCheckBoxMenuItem);
        this.openFrames.add(jInternalFrame);
        this.setWindowActionsEnabled(true);
        this.checkSize();
    }

    public void cycleToNextWindow() {
        this.cycleWindows(true);
    }

    public void cycleToPreviousWindow() {
        this.cycleWindows(false);
    }

    public void tileWindows() {
        int n;
        int n2 = this.openFrames.size();
        if (n2 == 0) {
            return;
        }
        this.resetSize();
        int n3 = n = (int)Math.sqrt(n2);
        int n4 = n;
        if (n3 * n4 < n2 && n3 * ++n4 < n2) {
            ++n3;
        }
        Dimension dimension = this.desktopPane.getSize();
        int n5 = dimension.width / n4;
        int n6 = dimension.height / n3;
        int n7 = 0;
        int n8 = 0;
        Iterator iterator = this.openFrames.iterator();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = 0;
            while (n10 < n4 && n9 * n4 + n10 < n2) {
                JInternalFrame jInternalFrame = (JInternalFrame)iterator.next();
                this.normalizeFrame(jInternalFrame);
                this.resizeFrame(jInternalFrame, n7, n8, n5, n6);
                n7 += n5;
                ++n10;
            }
            n7 = 0;
            n8 += n6;
            ++n9;
        }
    }

    public void stackWindows() {
        this.rollover = 0;
        this.newInternalY = 0;
        this.newInternalX = 0;
        Iterator iterator = this.openFrames.iterator();
        while (iterator.hasNext()) {
            JInternalFrame jInternalFrame = (JInternalFrame)iterator.next();
            this.normalizeFrame(jInternalFrame);
            Rectangle rectangle = this.getNextInternalFrameBounds();
            this.resizeFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.checkSize();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        if ("maximum".equals(string)) {
            if (this.maximizationInProgress) {
                return;
            }
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.resetSize();
            }
            this.anyFrameMaximized = bl;
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            this.maximizeAllFrames(jInternalFrame, bl);
        }
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        Iterator iterator = this.frameToMenuItem.values().iterator();
        while (iterator.hasNext()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)iterator.next();
            jCheckBoxMenuItem.setSelected(false);
        }
        ((JCheckBoxMenuItem)this.frameToMenuItem.get(jInternalFrame)).setSelected(true);
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        this.removeInternalFrame(jInternalFrame);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.parentFrame.desktopPane.remove(internalFrameEvent.getInternalFrame());
        this.checkSize();
    }

    public void endResizingFrame(JComponent jComponent) {
        super.endResizingFrame(jComponent);
        this.checkSize();
    }

    public void endDraggingFrame(JComponent jComponent) {
        super.endDraggingFrame(jComponent);
        this.checkSize();
    }

    public void checkSize() {
        Dimension dimension = new Dimension();
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n];
            dimension.width = Math.max(dimension.width, jInternalFrame.getX() + jInternalFrame.getWidth());
            dimension.height = Math.max(dimension.height, jInternalFrame.getY() + jInternalFrame.getHeight());
            ++n;
        }
        if (dimension.width > 0 && dimension.height > 0) {
            this.desktopPane.setPreferredSize(dimension);
        } else {
            this.desktopPane.setPreferredSize(null);
        }
        this.desktopPane.revalidate();
    }

    public void checkResizeInMaximizedState() {
        if (this.anyFrameMaximized) {
            this.resetSize();
        }
    }

    public void scrollToVisible(JInternalFrame jInternalFrame) {
        this.desktopPane.scrollRectToVisible(jInternalFrame.getBounds());
    }

    private void removeInternalFrame(JInternalFrame jInternalFrame) {
        JMenuItem jMenuItem = (JMenuItem)this.frameToMenuItem.remove(jInternalFrame);
        if (jMenuItem != null) {
            this.parentFrame.menuWindow.remove(jMenuItem);
            this.openFrames.remove(jInternalFrame);
            if (this.frameToMenuItem.size() == 0 && this.separatorMenuIndex > -1) {
                this.parentFrame.menuWindow.remove(this.separatorMenuIndex);
                this.separatorMenuIndex = -1;
                this.setWindowActionsEnabled(false);
            }
        }
    }

    private void resetSize() {
        this.desktopPane.setPreferredSize(null);
        this.desktopPane.invalidate();
        this.desktopPane.getParent().validate();
        this.parentFrame.scpDesktop.invalidate();
        this.parentFrame.scpDesktop.validate();
    }

    private void normalizeFrame(JInternalFrame jInternalFrame) {
        try {
            if (jInternalFrame.isIcon()) {
                jInternalFrame.setIcon(false);
            }
            if (jInternalFrame.isMaximum()) {
                jInternalFrame.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    private void cycleWindows(boolean bl) {
        JInternalFrame jInternalFrame = this.desktopPane.getSelectedFrame();
        ListIterator listIterator = this.openFrames.listIterator();
        while (listIterator.hasNext() && listIterator.next() != jInternalFrame) {
        }
        JInternalFrame jInternalFrame2 = bl ? (listIterator.hasNext() ? (JInternalFrame)listIterator.next() : (JInternalFrame)this.openFrames.getFirst()) : (listIterator.hasPrevious() && listIterator.previous() != null && listIterator.hasPrevious() ? (JInternalFrame)listIterator.previous() : (JInternalFrame)this.openFrames.getLast());
        try {
            if (jInternalFrame2.isIcon()) {
                jInternalFrame2.setIcon(false);
            }
            jInternalFrame2.setSelected(true);
            this.scrollToVisible(jInternalFrame2);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    private void setWindowActionsEnabled(boolean bl) {
        this.parentFrame.actionNextWindow.setEnabled(bl);
        this.parentFrame.actionPreviousWindow.setEnabled(bl);
        this.parentFrame.actionTileWindows.setEnabled(bl);
        this.parentFrame.actionStackWindows.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maximizeAllFrames(JInternalFrame jInternalFrame, boolean bl) {
        BasicDesktopManager basicDesktopManager = this;
        synchronized (basicDesktopManager) {
            if (this.maximizationInProgress) {
                return;
            }
            this.maximizationInProgress = true;
        }
        try {
            JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
            int n = 0;
            while (n < jInternalFrameArray.length) {
                if (jInternalFrameArray[n] != jInternalFrame) {
                    try {
                        jInternalFrameArray[n].setMaximum(bl);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            Object var8_8 = null;
            this.maximizationInProgress = false;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.maximizationInProgress = false;
            throw throwable;
        }
    }

    private class WindowActivateAction
    extends AbstractAction {
        private JInternalFrame frame;

        private WindowActivateAction(JInternalFrame jInternalFrame) {
            super(jInternalFrame.getTitle());
            this.frame = jInternalFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.frame.isIcon()) {
                    this.frame.setIcon(false);
                }
                if (this.frame.isSelected()) {
                    ((JCheckBoxMenuItem)actionEvent.getSource()).setSelected(true);
                } else {
                    this.frame.setSelected(true);
                }
                BasicDesktopManager.this.scrollToVisible(this.frame);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }
}

