/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class LocalVariableTableEntry
extends AbstractStructure {
    public static final int LENGTH = 10;
    private int startPc;
    private int length;
    private int nameIndex;
    private int descriptorIndex;
    private int index;

    public static LocalVariableTableEntry create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        LocalVariableTableEntry localVariableTableEntry = new LocalVariableTableEntry();
        localVariableTableEntry.setClassFile(classFile);
        localVariableTableEntry.read(dataInput);
        return localVariableTableEntry;
    }

    public int getStartPc() {
        return this.startPc;
    }

    public void setStartPc(int n) {
        this.startPc = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.startPc = dataInput.readUnsignedShort();
        this.length = dataInput.readUnsignedShort();
        this.nameIndex = dataInput.readUnsignedShort();
        this.descriptorIndex = dataInput.readUnsignedShort();
        this.index = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.startPc);
        dataOutput.writeShort(this.length);
        dataOutput.writeShort(this.nameIndex);
        dataOutput.writeShort(this.descriptorIndex);
        dataOutput.writeShort(this.index);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "LocalVariableTable entry with start_pc " + this.startPc + ", length " + this.length + ", name_index " + this.nameIndex + ", descriptor_index " + this.descriptorIndex + ", index " + this.index);
    }
}

