/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class PaddedInstruction
extends AbstractInstruction {
    public PaddedInstruction(int n) {
        super(n);
    }

    public int getPaddedSize(int n) {
        return this.getSize() + this.paddingBytes(n + 1);
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        int n = this.paddingBytes(byteCodeInput.getBytesRead());
        int n2 = 0;
        while (n2 < n) {
            byteCodeInput.readByte();
            ++n2;
        }
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        int n = this.paddingBytes(byteCodeOutput.getBytesWritten());
        int n2 = 0;
        while (n2 < n) {
            byteCodeOutput.writeByte(0);
            ++n2;
        }
    }

    private int paddingBytes(int n) {
        int n2 = 4 - n % 4;
        return n2 == 4 ? 0 : n2;
    }
}

